<?php

/*
// Simple META Management Suite for Joomla 1.5.x - Version 1.5.4 [Dragonbane]
//
// Licence:
//		AGPLv3 - http://www.aqsg.com.au/products/simple-meta-management-suite/licence.html
//
// Author:
//		Joel Bassett - http://www.aqsg.com.au
//
// Credits:
//		http://www.aqsg.com.au/products/simple-meta-management-suite/credits.html
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

// Import library dependencies
jimport('joomla.filesystem.folder');
jimport('joomla.filesystem.file');	

class SMMSUninstaller {
	function remove_sitemodule(&$installer, $modulename, &$db, $status) {
		$installer->parent->setPath('extension_root', JPATH_SITE . DS . 'modules' . DS . $modulename);
	
		// Get the package manifest objecct
		$installer->parent->setPath('source', $installer->parent->getPath('extension_root'));
	
		// Lets delete all the module copies for the type we are uninstalling
		$query = 'SELECT `id`' .
				' FROM `#__modules`' .
				' WHERE module = '.$db->Quote($modulename) .
				' AND client_id = '.(int)0;
		$db->setQuery($query);
		$modules = $db->loadResultArray();
	
		// Do we have any module copies?
		if (count($modules)) {
			JArrayHelper::toInteger($modules);
			$modID = implode(',', $modules);
			$query = 'DELETE' .
					' FROM #__modules_menu' .
					' WHERE moduleid IN ('.$modID.')';
			$db->setQuery($query);
			if (!$db->query()) {
				$status[$modulename]->name = $modulename;
				$status[$modulename]->text = JText::_('Unable to delete copies of Module from Database').': '.$db->stderr(true);
				return $status;
			}
		}
	
		// Delete the module in the #__modules table
		$query = 'DELETE FROM #__modules WHERE module = '.$db->Quote($modulename).' AND client_id = 0';
		$db->setQuery($query);
		if (!$db->query()) {
			$status[$modulename]->name = $modulename;
			$status[$modulename]->text = JText::_('Unable to delete the Module from the table').': '.$db->stderr(true);
			return $status;
		}
	
		// Remove the installation folder
		if (!JFolder::delete($installer->parent->getPath('extension_root'))) {
			// JFolder should raise an error
			$status[$modulename]->name = $modulename;
			$status[$modulename]->text = JText::_('Failed to delete module directory');
			return $status;
		}

		$status[$modulename]->name = $modulename;
		$status[$modulename]->text = JText::_('Module Removed');
		return $status;
	}

	function remove_adminmodule(&$installer, $modulename, &$db, $status) {
		$installer->parent->setPath('extension_root', JPATH_ADMINISTRATOR . DS . 'modules' . DS . $modulename);
	
		// Get the package manifest objecct
		$installer->parent->setPath('source', $installer->parent->getPath('extension_root'));
	
		// Lets delete all the module copies for the type we are uninstalling
		$query = 'SELECT `id`' .
				' FROM `#__modules`' .
				' WHERE module = ' . $db->Quote($modulename) .
				' AND client_id = '.(int)0;
		$db->setQuery($query);
		$modules = $db->loadResultArray();
	
		// Do we have any module copies?
		if (count($modules)) {
			JArrayHelper::toInteger($modules);
			$modID = implode(',', $modules);

			$query = 'DELETE' .
					' FROM #__modules' .
					' WHERE module = ' . $db->Quote($modulename);
			$db->setQuery($query);
			if (!$db->query()) {
				$status[$modulename]->name = $modulename;
				$status[$modulename]->text = JText::_('Unable to delete Module from Database').': '.$db->stderr(true);
				return $status;
			}

			$query = 'DELETE' .
					' FROM #__modules_menu' .
					' WHERE moduleid IN ('.$modID.')';
			$db->setQuery($query);
			if (!$db->query()) {
				$status[$modulename]->name = $modulename;
				$status[$modulename]->text = JText::_('Unable to delete copies of Module from Database').': '.$db->stderr(true);
				return $status;
			}
		}
	
		// Delete the module in the #__modules table
		$query = 'DELETE FROM #__modules WHERE module = '.$db->Quote($modulename).' AND client_id = 0';
		$db->setQuery($query);
		if (!$db->query()) {
			$status[$modulename]->name = $modulename;
			$status[$modulename]->text = JText::_('Unable to delete the Module from the table').': '.$db->stderr(true);
			return $status;
		}
	
		// Remove the installation folder
		if (!JFolder::delete($installer->parent->getPath('extension_root'))) {
			// JFolder should raise an error
			$status[$modulename]->name = $modulename;
			$status[$modulename]->text = JText::_('Failed to delete module directory');
			return $status;
		}

		$status[$modulename]->name = $modulename;
		$status[$modulename]->text = JText::_('Module Removed');
		return $status;
	}

	function remove_plugin(&$installer, $pluginname, $group='system', &$db, $status) { 	
		// Set the plugin root path
		$installer->parent->setPath('extension_root', JPATH_ROOT . DS . 'plugins' . DS . $group);
	
		// Delete the module in the #__modules table
		$query = 'DELETE FROM #__plugins WHERE element = '.$db->Quote($pluginname).' AND folder = '.$db->Quote($group);
		$db->setQuery($query);
		if (!$db->query()) {
			$status[$pluginname]->name = $pluginname;
			$status[$pluginname]->text = JText::_('Unable to delete Plugin from the table') . ': ' . $db->stderr(true);
			return $status;
		}
	
		// Set the installation path
		$element =& $installer->manifest->getElementByPath('plugins/plg_' . $pluginname . '/files');
		if (is_a($element, 'JSimpleXMLElement') && count($element->children())) {
			$installer->parent->removeFiles($element, -1);
		}
		// If the folder is empty, let's delete it
		$files = JFolder::files($installer->parent->getPath('extension_root'));
		if (!count($files)) {
			JFolder::delete($installer->parent->getPath('extension_root'));
		}
		
		//$filepath = $installer->parent->getPath('extension_root') . $pluginname;
		//if(file_exists($filepath . '.xml'))
		//	JFile::delete($filepath . '.xml');

		//if(file_exists($filepath . '.php'))
		//	JFile::delete($filepath . '.php');
			
		$status[$pluginname]->name = $pluginname;
		$status[$pluginname]->text = JText::_('Plugin Removed');
		return $status;
	}
	
	function remove_component($db, $uninstall_status) {
		$uninstall_status['com_smms']->name = 'com_smms';
		$uninstall_status['com_smms']->text = JText::_('Component Removed');
		return $uninstall_status;
	}

}

?>