<?php
/**
 * @package		EasyBlog
 * @copyright	Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 *
 * EasyBlog is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */

defined('_JEXEC') or die('Restricted access');
?>
<script type="text/javascript">
(function($){
	$(document).ready(function(){
		eblog.dashboard.lists.init( 'entries' );
	});
})(sQuery);
</script>
<div id="dashboard-entries" class="prel stackSelectGroup">
	<div class="dashboard-head clearfix">
		<div class="page_title entries_title float-l reset fsx fwb"><?php echo JText::_('COM_EASYBLOG_DASHBOARD_ENTRIES_PAGE_HEADING'); ?></div>
		<form name="search-entries" method="post" class="head-option float-r">
			<span class="float-l"><input type="text" name="post-search" class="input text width-150 search-head" id="post-search" value="<?php echo $search;?>" /></span>
            <span class="float-l"><a class="button-head tight" href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=dashboard&layout=write'); ?><?php echo ($system->config->get( 'layout_dashboardanchor' ) ) ? '#write-entry' : '';?>"><?php echo JText::_( 'COM_EASYBLOG_NEW_POST_BUTTON' );?></a></span>
		</form>
	</div>
	<div class="ui-optbox clearfix fsm">
		<ul class="entries-filter blog-navi-01 reset-ul float-li float-r">
			<li class="<?php echo $filter == 'all' ? 'active' : ''; ?>"><a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=dashboard&layout=entries&filter=all');?>"><?php echo JText::_('COM_EASYBLOG_FILTER_ALL'); ?></a></li>
			<li class="<?php echo $filter == 'published' ? 'active' : ''; ?>"><a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=dashboard&layout=entries&filter=published');?>"><?php echo JText::_('COM_EASYBLOG_FILTER_PUBLISHED'); ?></a></li>
			<li class="<?php echo $filter == 'unpublished' ? 'active' : ''; ?>"><a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=dashboard&layout=entries&filter=unpublished');?>"><?php echo JText::_('COM_EASYBLOG_FILTER_UNPUBLISHED'); ?></a></li>
			<li class="<?php echo $filter == 'scheduled' ? 'active' : ''; ?>"><a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=dashboard&layout=entries&filter=scheduled');?>"><?php echo JText::_('COM_EASYBLOG_FILTER_SCHEDULED'); ?></a></li>
		</ul>
		<div class="entries-select float-l">
			<?php if(!empty($this->acl->rules->publish_entry) || !empty($this->acl->rules->delete_entry) ) { ?>
			<ul class="ui-list-select-actions reset-ul float-li clearfix">
				<li>
					<input type="checkbox" class="stackSelectAll float-l" name="toggle" id="toggle"/>
					<label for="toggle" class="float-l mls mts"><?php echo JText::_( 'COM_EASYBLOG_SELECT_ALL' );?></label>
	            </li>
				<li id="select-actions">
					<select name="entries-action" id="entries-action">
						<option value="default"><?php echo JText::_('COM_EASYBLOG_WITH_SELECTED');?></option>
						<?php if( $this->acl->rules->publish_entry ){ ?>
							<option value="publishBlog"><?php echo JText::_('COM_EASYBLOG_PUBLISH');?></option>
							<option value="unpublishBlog"><?php echo JText::_('COM_EASYBLOG_UNPUBLISH');?></option>
						<?php } ?>
						<?php if( $this->acl->rules->delete_entry ){ ?>
							<option value="deleteBlog"><?php echo JText::_('COM_EASYBLOG_DELETE');?></option>
						<?php } ?>
					</select>
					<input type="button" class="ui-button" value="<?php echo JText::_('COM_EASYBLOG_APPLY_BUTTON');?>" onclick="eblog.dashboard.action( 'entries', 'index.php?option=com_easyblog&view=dashboard&layout=entries' );"/>
				</li>
			</ul>
			<?php } ?>
		</div>
	</div>
	<form name="entries-form" id="entries-form">
        <ul class="item_list reset-ul">

		<?php if ( $entries ) : ?>
		
			<?php $i = 0; ?>
			<?php foreach( $entries as $entry ):

			$blogAuthor =& EasyBlogHelper::getTable( 'Profile', 'Table' );
			$blogAuthor->load( $entry->created_by );

			$team   	= '';
			$teamBlog   = null;

			if( isset($entry->team_id) )
			{
			    if( !empty( $entry->team_id ) )
				{
					$team		= '&team=' . $entry->team_id;
					$teamBlog   =& EasyBlogHelper::getTable( 'TeamBlog', 'Table');
					$teamBlog->load( $entry->team_id );
				}
 			}

			?>
			<li id="eb-entry-<?php echo $entry->id; ?>">
				<div class="listing">
					<div class="item_title mbs">
						<a href="<?php echo EasyBlogRouter::_( 'index.php?option=com_easyblog&view=entry'.$team.'&id=' . $entry->id );?>" class="fsl fwb ffa"><?php echo $entry->title;?></a>
						<?php if( $entry->isFeatured ){ ?><sup class="featured-item"><?php echo JText::_( 'COM_EASYBLOG_FEATURED_FEATURED' );?></sup><?php } ?>
					</div>

					<span class="ui-list-select pabs"><input type="checkbox" class="stackSelect" value="<?php echo $entry->id; ?>" name="cid[]" id="cb<?php echo $i;?>" /></span>
	            	<ul class="ui-entry-meta clearfix reset-ul float-li mts">
						<li id="publishing-<?php echo $entry->id?>" class="ico-publish">
							<?php if ( $entry->published == 1 ) : ?>
								<a class="icon-published" href="javascript:void(0);" onclick="eblog.blog.togglePublish( '<?php echo $entry->id;?>' );"><?php echo JText::_('COM_EASYBLOG_PUBLISHED'); ?></a>
							<?php elseif($entry->published == 0) : ?>
								<a class="icon-unpublished" href="javascript:void(0);" onclick="eblog.blog.togglePublish( '<?php echo $entry->id;?>' );"><?php echo JText::_('COM_EASYBLOG_UNPUBLISHED'); ?></a>
							<?php elseif($entry->published == 2) : ?>
								<span class="icon-scheduled"><?php echo JText::_('COM_EASYBLOG_DASHBOARD_ENTRIES_POST_IS_SCHEDULED'); ?></span>
		                    <?php elseif($entry->published == 3) : ?>
		                    	<span class="icon-draft"><?php echo JText::_('COM_EASYBLOG_DRAFT');?></span>
							<?php endif; ?>
							<!-- TODO: SHOW SOCIAL SHARING IN TOOLTIP -->
						</li>
						<li class="ico-comments"><a href="<?php echo EasyBlogRouter::_( 'index.php?option=com_easyblog&view=entry&id=' . $entry->id . '#comment' );?>"><?php echo $this->getNouns( 'COM_EASYBLOG_COMMENTS_COUNT' , $entry->totalComments , true ); ?></a></li>
						<li class="ico-tags">
							<?php if (count($entry->_tags)>0): ?>
								<a href="javascript: void(0);"><?php echo $this->getNouns( 'COM_EASYBLOG_TAGS_COUNT' , count( $entry->_tags ) , true ); ?></a>
								<?php echo EasyBlogTooltipHelper::getTagsHTML( $entry->_tags, array('my'=>'left bottom','at'=>'left top','of'=>array('traverseUsing'=>'parent')) ); ?>
							<?php else: ?>
								<?php echo $this->getNouns( 'COM_EASYBLOG_TAGS_COUNT' , count( $entry->_tags ) , true ); ?>
							<?php endif; ?>
						</li>
						<li class="ico-category"><a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=categories&layout=listings&id=' . $entry->category_id); ?>" class="fsm"><?php echo $entry->category; ?></a></li>
	                </ul>
					<div class="clearfix mts">
	    				<div class="ui-date-share float-r">
       						<span class="post_date"><?php echo $this->formatDate( JText::_( 'DATE_FORMAT_LC1' ) ,  $entry->created); ?></span>
							<span class="ui-socialshare mls">
								<?php
									foreach( $consumers as $consumer )
									{
										$acl	= 'update_' . $consumer->type;
										if( isset( $this->acl->rules->$acl ) && $this->acl->rules->$acl && $system->config->get( 'integrations_' . $consumer->type . '_centralized_and_own' ) )
										{
											$shared	= $consumer->isShared( $entry->id );
											$state	= $shared ? '' : '_disabled';
								?>
										<a href="javascript:void(0)" onclick="eblog.socialshare.share('<?php echo $entry->id;?>' , '<?php echo $consumer->type;?>' );">
											<img id="oauth_img_<?php echo $consumer->type;?>_<?php echo $entry->id;?>" src="<?php echo JURI::root();?>/components/com_easyblog/assets/icons/socialshare/<?php echo $consumer->type . $state;?>.png" />
										</a>
										<div class="stackTip tipsA">
											<script type="text/x-json">({ my: 'right top', at: 'left bottom', of: { traverseUsing: 'prev' } })</script>
											<div id="ezttip">
												<div id="ezttip-in">
													<div id="ezttip-in-in">
													<?php if( $shared ){ ?>
											    		<span class="socialshare_<?php echo $consumer->type;?>"><?php echo JText::sprintf( 'COM_EASYBLOG_OAUTH_BLOG_ENTRY_SHARED_ON' , ucfirst( $consumer->type ) , $this->formatDate( $system->config->get('layout_dateformat'), $consumer->getSharedDate( $entry->id ) ) );?></span>
											    	<?php } else { ?>
											    		<span class="socialshare_<?php echo $consumer->type;?>"><?php echo JText::sprintf( 'COM_EASYBLOG_OAUTH_BLOG_ENTRY_NOT_SHARED' , ucfirst( $consumer->type ) );?></span>
											    	<?php } ?>
													</div>
												</div>
											</div>
										</div>
								<?php
										}
									}
								?>
							</span>
						</div>
						<span class="item_actions" id="eblog-comment-toolbar<?php echo $entry->id; ?>">
	    					<ul class="reset-ul float-li in-block">
	    						<?php if( $this->acl->rules->add_entry ) : ?>
	    						<li><a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=dashboard&layout=write&blogid='.$entry->id);?><?php echo ($system->config->get( 'layout_dashboardanchor' ) ) ? '#write-entry' : '';?>"><?php echo JText::_('COM_EASYBLOG_EDIT'); ?></a> </li>
	    						<?php endif; ?>

	    						<?php if( $this->acl->rules->delete_entry ) : ?>
	    						<li><a href="javascript:eblog.blog.confirmDelete('<?php echo $entry->id;?>', '<?php echo 'index.php?option=com_easyblog&view=dashboard&layout=entries'; ?>');"><?php echo JText::_('COM_EASYBLOG_DELETE'); ?></a></li>
	    						<?php endif; ?>
	    						<li><a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=entry'.$team.'&id='.$entry->id);?>"><?php echo JText::_( 'COM_EASYBLOG_PREVIEW' );?></a></li>
	    					</ul>
	    				</span>
	    				<span class="ui-inmsg mlm"></span>
					</div>

                    <div class="ui-authors ui-avatar pabs">
    				<?php if( !empty($team) ) : ?>
                        <!-- teamblog avatar -->
    			        <a href="<?php echo EasyBlogRouter::_('index.php?option=com_easyblog&view=teamblog&layout=listings&id=' . $teamBlog->id); ?>" title="<?php echo $teamBlog->title; ?>"  class="isTeamBlog pabs">
    						<img src="<?php echo $teamBlog->getAvatar(); ?>" alt="<?php echo $teamBlog->title; ?>" class="avatar" width="40" height="40" />
    					</a>
						<?php echo EasyBlogTooltipHelper::getTeamHTML( $teamBlog->id, array('my'=>'left bottom','at'=>'left top','of'=>array('traverseUsing'=>'prev')) ); ?>
                    <?php endif; ?>
    					<!-- blogger avatar -->
    			        <a href="<?php echo $blogAuthor->getProfileLink(); ?>" title="<?php echo $blogAuthor->getName(); ?>"  class="isBlogger pabs">
    						<img src="<?php echo $blogAuthor->getAvatar(); ?>" alt="<?php echo $blogAuthor->getName(); ?>" width="40" height="40" />
    					</a>
    				</div><!--end: .ui-authors-->
				</div>
			</li>
			<?php $i++; ?>
			<?php endforeach; ?>
			
		<?php else: ?>
            <li class="no_item">
                <div><?php echo JText::_('COM_EASYBLOG_DASHBOARD_ENTRIES_EMPTY'); ?></div>
            </li>
		<?php endif; ?>
        </ul>

        <?php if ( !empty($pagination) ) : ?>
			<div class="pagination"><?php echo $pagination->getPagesLinks(); ?></div>
		<?php endif; ?>
	</form>
</div>