<?php
/**
* @package		EasyBlog
* @copyright	Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* EasyBlog is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/
defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.application.component.view');
jimport( 'joomla.html.toolbar' );

class EasyBlogViewLatest extends EasyBlogView
{
	function display( $tmpl = null )
	{
		require_once( EBLOG_HELPERS . DS . 'image.php' );
		require_once( EBLOG_HELPERS . DS . 'date.php' );
		require_once( EBLOG_HELPERS . DS . 'integrate.php' );
		require_once( EBLOG_HELPERS . DS . 'helper.php' );
		require_once( EBLOG_CLASSES . DS . 'facebook.php' );

		// set meta tags for latest post
		EasyBlogHelper::setMeta( META_ID_LATEST, META_TYPE_VIEW );

		// set rss into headers
		EasyBlogHelper::getHelper( 'Feeds' )->addHeaders( 'index.php?option=com_easyblog&view=latest' );

		JPluginHelper::importPlugin( 'easyblog' );
		$dispatcher = JDispatcher::getInstance();
		$mainframe	= JFactory::getApplication();
		$document	= JFactory::getDocument();
		$config		= EasyBlogHelper::getConfig();
		$my         = JFactory::getUser();
		$acl 		= EasyBlogACLHelper::getRuleSet();

		if( ! EasyBlogRouter::isCurrentActiveMenu( 'latest' ) )
			$this->setPathway( JText::_('COM_EASYBLOG_LATEST_BREADCRUMB') , '' );


		$menu 		= JFactory::getApplication()->getMenu()->getActive();
		$inclusion	= '';

		if( is_object( $menu ) )
		{
			$params 	= new JParameter( $menu->params );
			$inclusion	= $params->get( 'inclusion' );
		}

		$sort			= JRequest::getCmd('sort', $config->get( 'layout_postorder' ) );
		$model			= $this->getModel( 'Blog' );

		$featured   	= $model->getFeaturedBlog( $inclusion );
		$featuredIds    = array();

		foreach($featured as $item)
		{
			$featuredIds[]  = $item->id;
		}

		if( !$config->get( 'layout_featured_allpages') && ( JRequest::getInt( 'start' , 0 ) != 0 || JRequest::getInt( 'limitstart' , 0 ) != 0 ) )
		{
			$featured 	= array();
		}
		else
		{
			for( $i = 0; $i < count( $featured ); $i++ )
			{
				$row					= $featured[ $i ];
				$row->featuredImage		= EasyBlogHelper::getFeaturedImage( $row->intro . $row->content );
			}

			$featured	= EasyBlogHelper::formatBlog( $featured , true , false );
		}

		$excludedCategories	= $config->get( 'layout_exclude_categories' );
		$excludedCategories	= explode( ',' , $excludedCategories );

		$data		= $model->getBlogsBy('', '', $sort , 0 , EBLOG_FILTER_PUBLISHED, null, true, $featuredIds , false , false , true , $excludedCategories , $inclusion );

		$pagination	= $model->getPagination();
		$params		= $mainframe->getParams('com_easyblog');
		$limitstart	= JRequest::getVar('limitstart', 0, '', 'int');
		$data		= EasyBlogHelper::formatBlog( $data , true , true , true , true );

		$pageTitle	= EasyBlogHelper::getPageTitle($config->get('main_title'));
		$pageNumber	= $pagination->get( 'pages.current' );
		$pageText	= ($pageNumber == 1) ? '' : ' - ' . JText::sprintf( 'COM_EASYBLOG_PAGE_NUMBER', $pageNumber );
		$document->setTitle( EasyBlogHelper::getPageTitle( JText::_( 'COM_EASYBLOG_LATEST_PAGE_TITLE' ) ) . $pageText );

		$theme		= new CodeThemes();
		$theme->set('data'		, $data );
		$theme->set('featured'	, $featured );
		$theme->set( 'currentURL' , 'index.php?option=com_easyblog&view=latest' );
		$theme->set('pagination', $pagination->getPagesLinks());
		$theme->set('my'		, $my );
		$theme->set('acl'		, $acl );

		$html		= $theme->fetch( 'blog.latest.php' );

		echo $html;
	}
}
