(function($){

$.Controller(
	'EasyBlog.FileManager.Browser.ItemHandler.Video',
	{
		defaults: {
			'{insertButton}': '.video-insert-button',
			'{deleteButton}': '.video-delete-button',
			'@Item': 'EasyBlog.FileManager.Browser.ItemHandler.Video.Item',
			'@Placeholder' : 'EasyBlog.FileManager.Browser.PreviewHandler.Video.Placeholder'
		}
	},
	function(self) { return {

		init: function(el, options)
		{
			self.fileManager = this.options.fileManager;

			self.render(function(html)
			{
				self.element.html(html);
			});
		},

		render: function(callback)
		{
			$.View(
				self.template('Item'),
				self.options.properties,
				function(html)
				{
					return callback && callback.apply(self, [html]);
				}
			);
		},

		"{insertButton} click": function(el, event)
		{
			event.stopPropagation();
			self.insertVideo();
		},

		"{deleteButton} click": function(el, event)
		{
			event.stopPropagation();
			self.deleteVideo();
		},
				
		insertVideo: function(options)
		{
			var video = self.options.properties,
				name = video.name;

			if( $.isPlainObject(options) )
			{
				video = $.extend( '' , video , options );
			}

			var obj = $.toJSON( { 'path' : video.path , 'name' : name , 'width' : video.width , 'height' : video.height , 'autoplay' : video.autoplay } );

			// Replace the quotes with single quotes.
			obj	= obj.replace(/"/g, "'");

			$.View(
				self.template('Placeholder'),
				{
					name: name,
					obj: obj,
					width: video.width,
					height: video.height
				},
				function(html)
				{
					self.fileManager.operations.insertIntoEditor( html );
				}
			);
		},

		deleteVideo: function()
		{
			if(confirm($.lang('COM_EASYBLOG_DELETE_FILE_CONFIRMATION')))
			{	
				self.fileManager.browser.setContentPaneMessage($.lang('COM_EASYBLOG_DELETING') + ' "' + self.options.properties.name + '"...');

				self.fileManager.operations.removeItem(self.options.properties,
				{
					success: function()
					{
						self.fileManager.browser.setContentPaneMessage($.lang('COM_EASYBLOG_DELETED') + ' "' + self.options.properties.name + '"!', 'topAndFade');

						self.fileManager.browser.removeItem(self);
					},
					error: function()
					{
						self.fileManager.browser.setContentPaneMessage($.lang('COM_EASYBLOG_ERROR_DELETING') + ' "' + self.options.properties.name + '"!', 'topAndFade');
					}
				});
			}			
		}		

	}}
);
})(Foundry);