(function($){

$.Controller(
	'EasyBlog.FileManager.Browser.PreviewHandler.Video',
	{
		defaults:
		{
			'{itemPreview}'	    : '.item-preview',
			'{itemProperties}'	: '.item-properties',

			'{insertButton}'	: '.video-insert-button',
			'{deleteButton}'	: '.video-delete-button',

			'{videoPreview}'    : '.video-preview',
			'{videoTitle}'		: '#video-title',
			'{videoAutoPlay}'	: '#video-autoplay',
			'{videoWidth}'       : '#video-width',
			'{videoHeight}'      : '#video-height',
			'@Editor': 'EasyBlog.FileManager.Browser.PreviewHandler.Video.Editor'
		}	
	},
	function(self) { return {
		init: function()
		{
			self.fileManager = self.options.fileManager;
			self.meta = self.options.properties;

			self.render(function(html)
			{
				self.element.append(html);
			});
		},

		render: function(callback)
		{
			$.View(
				self.template('Editor'),
				self.options.properties,
				function(html)
				{
					return callback && callback.apply(self, [html]);
				}
			);
		},
		setLayout: function()
		{
			self.itemPreview().css('height', self.element.height() - self.itemProperties().outerHeight() - (self.itemPreview().outerHeight() - self.itemPreview().height()));
		
			self.videoPreview()
				.css(
				{
					'width'   : self.itemPreview().width(),
					'height'  : self.itemPreview().width() / 16 * 9,
					'top'     : (self.itemPreview().height() - (self.itemPreview().width() / 16 * 9)) / 2
				});
			
			$([self.videoTitle() ]).stretchToFit();
		},

		"{insertButton} click" : function(el, event)
		{
			self.itemHandler.insertVideo();
// 			self.itemHandler.insertVideo({
// 					'width' : self.videoWidth().val(),
// 					'height': self.videoHeight().val(),
// 					'autoplay' : self.videoAutoPlay().val()
// 			});
		},
		"{deleteButton} click": function()
		{
			self.itemHandler.deleteVideo();
		}
	}}
);
})(Foundry);