(function($){
$.Controller(
	'EasyBlog.FileManager.Toolbar.Upload',
	{
		defaults: {
			'{progress}': '.upload-progress',
			'{progressBar}': '.upload-progress-bar',
			'{progressValue}': '.upload-progress-value',
			'{startButton}': '#upload-start-button',
			'{stopButton}': '#upload-stop-button'
		}
	},
	function(self) { return {

		init: function()
		{
			self.fileManager = self.options.fileManager;
		},

		activate: function()
		{
			self.fileManager.toolbar.element.addClass('uploading');

			self.element.addClass('active');

			self.fileManager.toolbar.search.deactivate();

			self.fileManager.toolbar.search.element.hide();

			self.fileManager.toolbar.pathway.element.hide();

			self.setLayout();
		},

		deactivate: function()
		{
			self.fileManager.toolbar.element.removeClass('uploading');

			self.element.removeClass('active');

			self.fileManager.toolbar.search.element.show();

			self.fileManager.toolbar.pathway.element.show();
		},

		setLayout: function()
		{
			var width = self.element.width() - self.stopButton().outerWidth(true) - (self.progress().outerWidth(true) - self.progress().width());

			self.progress().css('width', width);

			self.fileManager.toolbar.element
				.css('padding-right', self.startButton().outerWidth(true) + 10);
			
			self.element
				.css('padding-right', self.startButton().outerWidth(true));

			try {
				var plupload = self.fileManager.uploader.plupload;
				if (plupload) plupload.refresh();				
			} catch(e) {};

		},

		pseudoProgress: 0,

		setProgress: function()
		{
			(function()
			{
				if (self.pseudoProgress >= 100) return;

				// Defer progress calculation if item handlers are not ready
				var itemHandlers = self.fileManager.uploader.itemHandlers;
				if ($.isEmptyObject(itemHandlers))
				{
					setTimeout(arguments.callee, 250);
					return;
				}

				// Go through every item handler and calculate total progress
				var max=0, val=0;

				$.each(itemHandlers, function(i, itemHandler)
				{
					max += 100;
					val += itemHandler.pseudoProgress;
				});

				val = Math.floor((val/max)*100);

				// Expand progress bar gradually over time
				self.progressBar()
					.stop()
					.animate({width: val + '%'},
					{
						duration: 250,
						step: function(val)
						{
							self.progressValue()
								.html(Math.ceil(val) + '%');
						},
						complete: (val >= 100) ? function(){} : arguments.callee
					});
			})();
		},

		resetProgress: function()
		{
			self.pseudoProgress = 0;

			self.progressBar()
				.stop()
				.width(0);

			self.progressValue()
				.html('0%');
		},

		'{stopButton} click': function()
		{
			self.fileManager.uploader.stop();
			self.deactivate();
		}
	}}
);
})(Foundry);