<?php
/**
 * @package		EasyBlog
 * @copyright	Copyright (C) 2010 Stack Ideas Private Limited. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 *
 * EasyBlog is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.filesystem.file' );

$path	= JPATH_ROOT.DS.'components'.DS.'com_easyblog'.DS.'helpers' . DS . 'helper.php';

if( !JFile::exists( $path ) )
{
	return;
}
require_once( $path );
require_once (JPATH_ROOT.DS.'components'.DS.'com_easyblog'.DS.'helpers'.DS.'router.php');
require_once (JPATH_ROOT.DS.'components'.DS.'com_easyblog'.DS.'helpers'.DS.'date.php');

EasyBlogHelper::loadHeaders();
EasyBlogHelper::loadModuleCss();

if( !class_exists( 'EasyBlogModelArchive' ) )
{
	jimport( 'joomla.application.component.model' );
	JLoader::import( 'archive' , EBLOG_ROOT . DS . 'models' );
}
$model			=& JModel::getInstance( 'Archive' , 'EasyBlogModel' );
$year			= $model->getArchiveMinMaxYear();

if( !$year )
{
	return;
}

$currentMonth	= (int) JFactory::getDate()->toFormat( '%m' );
$currentYear	= (int) JFactory::getDate()->toFormat( '%Y' );

JHTML::script('script.js', rtrim(JURI::root(), '/') . '/modules/mod_easyblogarchive/');

$count = $params->get( 'count', 0 );

if(!empty($count))
{
	if(($year['maxyear'] - $year['minyear']) > $count)
	{
		$year['minyear'] = $year['maxyear'] - $count;
	}
}

//set default year
$defaultYear	= JRequest::getVar( 'archiveyear' , $year['maxyear'] , 'REQUEST' );

//set default month
$defaultMonth	= JRequest::getVar( 'archivemonth' , 0 , 'REQUEST' );

$excludeCats	= $params->get( 'catid', '');

$modItemId	= $params->get( 'moditemid', '');
$modItemId	= (! empty($modItemId)) ? '&Itemid='.$modItemId : '';

//get post count for a particular year
$postCounts		= $model->getArchivePostCount( $year['minyear'] , $year['maxyear'], $excludeCats );
require( JModuleHelper::getLayoutPath('mod_easyblogarchive') );
