/**
 *  This file fixes an issue with Joomla 1.5.14+ and TinyMCE Editor 3.2.4.1
 *  TinyMCE adds extra information to script tags such as mce: , mce_ and mce-
 *  These need to be removed before the content is saved to the database for proper
 *  display in the front end.
 */

/**
 *
 * @param {Object} ed TinyMCE Editor Instance
 * @param {Object} o Obejct that contains the content of the textarea.
 */
function filterJSContent(ed, o){
	if(!o.content) return;
	var content = o.content;
	if(content.search(/maps\.google\.com/g) != -1){
		content = content.replace(/mce:/g, '');
		content = content.replace(/mce_/g, '');
		o.content = content.replace(/mce-/g, '');
	}
}

/**
 * Installs the filter for TinyMCE when the editor becomes active.
 */
function installJSFilter(){
	if(tinyMCE.activeEditor){
			tinyMCE.activeEditor.onSaveContent.add(filterJSContent);
	}else{
		setTimeout(installJSFilter, 20);
	}
}
/**
 * Start the timeout function for filter installation.
 */
window.addEvent("domready", function() {
	if(tinyMCE.majorVersion = '3'){
		setTimeout(installJSFilter, 20);
	}
});