/**
 * 
 * @param evt Keyboard event.
 * @param filter Regular Expression. RegEx object.
 * @return
 */
function InputFilter( evt , filter ){
	var keyCode, Char, inputField;

	if(window.event){
		keyCode = window.event.keyCode;
		evt = window.event;
	}else if (evt){
		keyCode = evt.which;
	}else return true;

	// Get the Element that triggered the Event
	inputField = evt.srcElement ? evt.srcElement : evt.target || evt.currentTarget;

	// If the Key Pressed is a CTRL key like Esc, Enter etc - allow
	Char = String.fromCharCode(keyCode);
	// Backspace = 8, TAB = 9, Enter = 13, Esc = 28
	if((keyCode==null) || (keyCode==0) || (keyCode==8) || (keyCode==9) || (keyCode==13) || (keyCode==27) )return true;
	var caretPos = getCaretPosition(inputField);
	var str = insertChar(inputField.value , Char, caretPos);

	// If the Character is a number - allow
	if( filter.test( str ) ){
		return true;
	}else{
		return false;
	}
}

function insertChar(str, a, position){
	if(position == 0) return a + str;

	if(str.length == position)
		return str + a;

	return str.substr(0,position) + a + str.substr(position + 1);
}


function getCaretPosition (oField) {
	// Initialize
	var iCaretPos = 0;

	if (document.selection) { // IE Support

		// Set focus on the element
		oField.focus ();

		// To get cursor position, get empty selection range
		var oSel = document.selection.createRange ();

		// Move selection start to 0 position
		oSel.moveStart ('character', -oField.value.length);

		// The caret position is selection length
		iCaretPos = oSel.text.length;
	}else if (oField.selectionStart || oField.selectionStart == '0'){
		//Firefox support
		iCaretPos = oField.selectionStart;
	}

	// Return results
	return (iCaretPos);
}

/**
 * Filters a number of integers. 
 * @param event Keyboard event.
 * @param [n] Number of integers
 * @return
 */
function FilterInteger(event, n){
	var regEx;
	if(n === undefined){
		regEx = /^[1-9]\d*$/;
	}else{
		regEx = INTEGER(n);
	}
	return InputFilter(event, regEx);
}

/**
 * 
 * @param n Number of characters.
 */
function INTEGER(n){
	return new RegExp( "^[1-9]\\d{0," + (n - 1) + "}$" );
}
var NUMBEIC = /^\d*$/, HEXIDECIMAL = /^[ABCDEFabcdef\d]*$/;

var INTEGERx = /^[1-9]\d*$/  , INTEGER3 = /^[1-9]\d{0,2}$/, INTEGER2 = /^[1-9]\d{0,1}$/;

var FLOAT= /^1|0?\.\d*$/;
var FLOAT_1 = /^((1)|(1\.)|(1\.0)|(0)|(0\.)|(0\.[\d]+)|(\.)|(\.[\d]+))$/; //// 0.0 to 1.0
