<?php

/*
// Simple META Management Suite for Joomla 1.5.x - Version 1.5.4 [Dragonbane]
//
// Licence:
//		AGPLv3 - http://www.aqsg.com.au/products/simple-meta-management-suite/licence.html
//
// Author:
//		Joel Bassett - http://www.aqsg.com.au
//
// Credits:
//		http://www.aqsg.com.au/products/simple-meta-management-suite/credits.html
*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

// Import library dependencies
jimport( 'joomla.plugin.plugin' );
jimport( 'joomla.environment.uri' );


class  plgSystemSMMS extends JPlugin {
	var $pageMETA = null;

	function plgSystemSMMSplg(& $subject, $config) {
		parent::__construct($subject, $config);
	}

	function onAfterInitialise() {
		global $mainframe;
		
		if (!JComponentHelper::isEnabled('com_smms', true))
		{
			JError::raiseError('E_SMMSNOTENABLED', JText('SMMS_GLOBAL_ERROR_NOTENABLED'));
			return;
		}

		require_once( JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_smms' . DS . 'models' . DS . 'settings.php' );
	
		$settings 							=& SMMSModelSettings::getInstance();
		$enable_canonicalization 			= $settings->get('core_enablecanonicalization', 0);
		$canonicalization_host 				= $settings->get('core_canonicalizationhost', '');
		$canonicalization_forcessl			= $settings->get('core_canonicalizationforcessl', 0);
		$redirecturl						= false;

		if (($enable_canonicalization) && (!$mainframe->isAdmin())) {
			$uriofscript 	=& JURI::getInstance();
			$hostofscript	=& $uriofscript->getHost();
	
			if ((!empty($canonicalization_host)) && (!(@$hostofscript == $canonicalization_host))) {
				$redirecturl = true;
				$uriofscript->setHost($canonicalization_host);
			}

			if ((!$uriofscript->isSSL()) && $canonicalization_forcessl) {
				$redirecturl = true;
				$uriofscript->setScheme('https');
			}
			
			if ($redirecturl) {
				$correcturl = $uriofscript->toString();
				header('Location: '. $correcturl, true, 301);
				$app = & JFactory::getApplication();
				$app->close();
			}
		}
	}
	
	//GEORGE BARDIS creating the logo alts and titles //////////////
	function onAfterRoute() {
		global $mainframe;
		
		if (!JComponentHelper::isEnabled('com_smms', true))
		{
			JError::raiseError('E_SMMSNOTENABLED', JText('SMMS_GLOBAL_ERROR_NOTENABLED'));
			return;
		}

		$db 			=& JFactory::getDBO();
		$document 		=& JFactory::getDocument();
		$uriofscript 	=& JURI::getInstance();

		if (!$mainframe->isAdmin()) {
			require_once( JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_smms' . DS . 'functions' 	. DS . 'common.php' );
			require_once( JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_smms' . DS . 'functions' 	. DS . 'plugin.php' );
			require_once( JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_smms' . DS . 'models' 	. DS . 'settings.php' );
			$query	= 'SELECT'
					. ' name'
					. ' FROM #__smms_modules'
					. ' WHERE enabled = 1'
					. ' ORDER BY id';						
			$db->setQuery($query);
			$modules = $db->loadObjectList();
			if (count($modules) != 0)
				foreach ($modules as $module) {
					if (file_exists(JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_smms' . DS . 'extensions'	. DS . 'ext.' . $module->name . '.php' ))
						require_once(JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_smms' . DS . 'extensions'	. DS . 'ext.' . $module->name . '.php' );
				}
		} else {
			return;
		}
		
		$optionofscript = $uriofscript->getVar('option');
		if (empty($optionofscript))
			$optionofscript = JRequest::getVar('option');
		

		if ($document->getType() == 'html') {
			if (JURI::isInternal($uriofscript->toString())) {
				$PageContent = JResponse::getBody();
				$PageContent = SimpleMETAManagementFunctions_plugin::miscPageFunctions($PageContent);
				if ($checkComponent = SimpleMETAManagementFunctions_plugin::checkComponent($optionofscript))
					$PageContent = SimpleMETAManagementFunctions_plugin::doMetaReplacement($PageContent, $checkComponent);
				JResponse::setBody($PageContent);
			}
		}
	
	}
	//GEORGE BARDIS ENDS //////////////

	function onAfterRender() {
		global $mainframe;
		
		if (!JComponentHelper::isEnabled('com_smms', true))
		{
			JError::raiseError('E_SMMSNOTENABLED', JText('SMMS_GLOBAL_ERROR_NOTENABLED'));
			return;
		}

		$db 			=& JFactory::getDBO();
		$document 		=& JFactory::getDocument();
		$uriofscript 	=& JURI::getInstance();

		if (!$mainframe->isAdmin()) {
			require_once( JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_smms' . DS . 'functions' 	. DS . 'common.php' );
			require_once( JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_smms' . DS . 'functions' 	. DS . 'plugin.php' );
			require_once( JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_smms' . DS . 'models' 	. DS . 'settings.php' );
			$query	= 'SELECT'
					. ' name'
					. ' FROM #__smms_modules'
					. ' WHERE enabled = 1'
					. ' ORDER BY id';						
			$db->setQuery($query);
			$modules = $db->loadObjectList();
			if (count($modules) != 0)
				foreach ($modules as $module) {
					if (file_exists(JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_smms' . DS . 'extensions'	. DS . 'ext.' . $module->name . '.php' ))
						require_once(JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_smms' . DS . 'extensions'	. DS . 'ext.' . $module->name . '.php' );
				}
		} else {
			return;
		}
		
		$optionofscript = $uriofscript->getVar('option');
		if (empty($optionofscript))
			$optionofscript = JRequest::getVar('option');
		

		if ($document->getType() == 'html') {
			if (JURI::isInternal($uriofscript->toString())) {
				$PageContent = JResponse::getBody();
				$PageContent = SimpleMETAManagementFunctions_plugin::miscPageFunctions($PageContent);
				if ($checkComponent = SimpleMETAManagementFunctions_plugin::checkComponent($optionofscript))
					$PageContent = SimpleMETAManagementFunctions_plugin::doMetaReplacement($PageContent, $checkComponent);
				JResponse::setBody($PageContent);
			}
		}
	
	}
	
}

?>